/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.io.FileWrapper;
import com.android.sdklib.io.FolderWrapper;
import com.android.sdklib.io.IAbstractFile;
import com.android.sdklib.io.IAbstractFolder;
import com.android.sdklib.xml.AndroidManifest;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetupTask
extends ImportTask {
    private static final int ANT_RULES_MAX_VERSION = 3;
    private static final String RULES_LEGACY_MAIN = "android_rules.xml";
    private static final String RULES_LEGACY_TEST = "android_test_rules.xml";
    private static final String RULES_MAIN = "ant_rules_r%1$d.xml";
    private static final String RULES_TEST = "ant_test_rules_r%1$d.xml";
    private static final String RULES_LIBRARY = "ant_lib_rules_r%1$d.xml";
    private static final String PROPERTY_ANDROID_JAR = "android.jar";
    private static final String PROPERTY_ANDROID_AIDL = "android.aidl";
    private static final String PROPERTY_AAPT = "aapt";
    private static final String PROPERTY_AIDL = "aidl";
    private static final String PROPERTY_DX = "dx";
    private static final String REF_CLASSPATH = "android.target.classpath";
    private static final int[][] ANT_COMPATIBILITY_RANGES = new int[][]{{1, 1}, {2, 3}};
    private boolean mDoImport = true;

    public void execute() throws BuildException {
        Project antProject = this.getProject();
        File sdk = TaskHelper.getSdkLocation(antProject);
        String sdkLocation = sdk.getPath();
        int toolsRevison = TaskHelper.getToolsRevision(sdk);
        if (toolsRevison != -1) {
            System.out.println("Android SDK Tools Revision " + toolsRevison);
        }
        String targetHashString = antProject.getProperty("target");
        boolean isTestProject = false;
        if (antProject.getProperty("tested.project.dir") != null) {
            isTestProject = true;
        }
        if (targetHashString == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList messages = new ArrayList();
        SdkManager manager = SdkManager.createManager((String)sdkLocation, (ISdkLog)new ISdkLog(){

            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    messages.add(String.format("Error: " + errorFormat, args));
                }
                if (t != null) {
                    messages.add("Error: " + t.getMessage());
                }
            }

            public void printf(String msgFormat, Object ... args) {
                messages.add(String.format(msgFormat, args));
            }

            public void warning(String warningFormat, Object ... args) {
                messages.add(String.format("Warning: " + warningFormat, args));
            }
        });
        if (manager == null) {
            for (String msg : messages) {
                System.out.println(msg);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget androidTarget = manager.getTargetFromHashString(targetHashString);
        if (androidTarget == null) {
            throw new BuildException(String.format("Unable to resolve target '%s'", targetHashString));
        }
        System.out.println("Project Target: " + androidTarget.getName());
        if (!androidTarget.isPlatform()) {
            System.out.println("Vendor: " + androidTarget.getVendor());
            System.out.println("Platform Version: " + androidTarget.getVersionName());
        }
        System.out.println("API level: " + androidTarget.getVersion().getApiString());
        int antBuildVersion = androidTarget.getProperty("sdk.ant.build.revision", Integer.valueOf(1));
        if (antBuildVersion > 3) {
            antBuildVersion = 3;
            System.out.println("\n\n\n***********************************************************\nWARNING: This platform requires Ant build rules not supported by your SDK Tools.\nWARNING: Attempting to use older build rules instead, but result may not be correct.\nWARNING: Please update to the newest revisions of the SDK Tools.\n***********************************************************\n\n\n");
        }
        if (antBuildVersion < 2) {
            if (androidTarget.getVersion().getApiLevel() < 3 || androidTarget.getVersion().getApiLevel() == 5 || androidTarget.getVersion().getApiLevel() == 6) {
                System.out.println("\n\n\n***********************************************************\nWARNING: This platform is obsolete and its Ant rules may not work properly.\nWARNING: It is recommended to develop against a newer version of Android.\nWARNING: For more information about active versions of Android see:\nWARNING: http://developer.android.com/resources/dashboard/platform-versions.html\n***********************************************************\n\n\n");
            } else {
                IAndroidTarget baseTarget = androidTarget.getParent() != null ? androidTarget.getParent() : androidTarget;
                System.out.println(String.format("\n\n\n***********************************************************\nWARNING: Revision %1$d of %2$s uses obsolete Ant rules which may not work properly.\nWARNING: It is recommended that you download a newer revision if available.\nWARNING: For more information about updating your SDK, see:\nWARNING: http://developer.android.com/sdk/adding-components.html\n***********************************************************\n\n\n", baseTarget.getRevision(), baseTarget.getFullName()));
            }
        }
        antProject.setProperty("android.ant.rules.revision", Integer.toString(antBuildVersion));
        boolean isLibrary = false;
        String libraryProp = antProject.getProperty("android.library");
        if (libraryProp != null) {
            isLibrary = Boolean.valueOf(libraryProp);
        }
        if (isLibrary) {
            System.out.println("Project Type: Android Library");
        }
        if (isLibrary && !androidTarget.getProperty("sdk.build.support.library", Boolean.valueOf(false)).booleanValue()) {
            throw new BuildException(String.format("Project target '%1$s' does not support building libraries.", androidTarget.getFullName()));
        }
        this.processReferencedLibraries(antProject, androidTarget);
        this.checkManifest(antProject, androidTarget.getVersion());
        String androidJar = androidTarget.getPath(1);
        antProject.setProperty(PROPERTY_ANDROID_JAR, androidJar);
        String androidAidl = androidTarget.getPath(2);
        antProject.setProperty(PROPERTY_ANDROID_AIDL, androidAidl);
        antProject.setProperty(PROPERTY_AAPT, androidTarget.getPath(20));
        antProject.setProperty(PROPERTY_AIDL, androidTarget.getPath(21));
        antProject.setProperty(PROPERTY_DX, androidTarget.getPath(22));
        Path bootclasspath = new Path(antProject);
        Path.PathElement element = bootclasspath.createPathElement();
        element.setPath(androidJar);
        IAndroidTarget.IOptionalLibrary[] libraries = androidTarget.getOptionalLibraries();
        if (libraries != null) {
            HashSet<String> visitedJars = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary library : libraries) {
                String jarPath = library.getJarPath();
                if (visitedJars.contains(jarPath)) continue;
                visitedJars.add(jarPath);
                element = bootclasspath.createPathElement();
                element.setPath(library.getJarPath());
            }
        }
        antProject.addReference(REF_CLASSPATH, (Object)bootclasspath);
        if (this.mDoImport) {
            File rulesFolder;
            int toolsRulesRev = this.getAntRulesFromTools(antBuildVersion);
            if (toolsRulesRev == -1) {
                int folderID = antBuildVersion == 1 ? 6 : 24;
                String rulesOSPath = androidTarget.getPath(folderID);
                rulesFolder = new File(rulesOSPath);
            } else {
                rulesFolder = new File(new File(sdkLocation, "tools"), "ant");
                antBuildVersion = toolsRulesRev;
            }
            if (!rulesFolder.isDirectory()) {
                throw new BuildException(String.format("Rules directory '%s' is missing.", rulesFolder.getAbsolutePath()));
            }
            String importedRulesFileName = antBuildVersion == 1 ? (isTestProject ? RULES_LEGACY_TEST : RULES_LEGACY_MAIN) : String.format(isLibrary ? RULES_LIBRARY : (isTestProject ? RULES_TEST : RULES_MAIN), antBuildVersion);
            File rules = new File(rulesFolder, importedRulesFileName);
            if (!rules.isFile()) {
                throw new BuildException(String.format("Build rules file '%s' is missing.", rules));
            }
            String rulesLocation = rules.getAbsolutePath();
            if (rulesLocation.startsWith(sdkLocation) && (rulesLocation = rulesLocation.substring(sdkLocation.length())).startsWith(File.separator)) {
                rulesLocation = rulesLocation.substring(1);
            }
            System.out.println("\nImporting rules file: " + rulesLocation);
            this.setFile(rules.getAbsolutePath());
            super.execute();
        }
    }

    private int getAntRulesFromTools(int rulesRev) {
        for (int[] range : ANT_COMPATIBILITY_RANGES) {
            if (range[0] > rulesRev || rulesRev > range[1]) continue;
            return range[1];
        }
        return -1;
    }

    public void setImport(boolean value) {
        this.mDoImport = value;
    }

    private void checkManifest(Project antProject, AndroidVersion androidVersion) {
        block12: {
            try {
                File manifest = new File(antProject.getBaseDir(), "AndroidManifest.xml");
                XPath xPath = AndroidXPathFactory.newXPath();
                String value = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifest)));
                if (value != null && value.indexOf(46) == -1) {
                    throw new BuildException(String.format("Application package '%1$s' must have a minimum of 2 segments.", value));
                }
                value = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(new FileInputStream(manifest)));
                if (androidVersion.isPreview()) {
                    String codeName = androidVersion.getCodename();
                    if (!codeName.equals(value)) {
                        throw new BuildException(String.format("For '%1$s' SDK Preview, attribute minSdkVersion in AndroidManifest.xml must be '%1$s'", codeName));
                    }
                    break block12;
                }
                if (value.length() > 0) {
                    int minSdkValue = -1;
                    try {
                        minSdkValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        throw new BuildException(String.format("Attribute %1$s in AndroidManifest.xml must be an Integer!", "minSdkVersion"));
                    }
                    int projectApiLevel = androidVersion.getApiLevel();
                    if (minSdkValue < projectApiLevel) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is lower than the project target API level (%3$d)", "minSdkVersion", minSdkValue, projectApiLevel));
                    } else if (minSdkValue > androidVersion.getApiLevel()) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is higher than the project target API level (%3$d)", "minSdkVersion", minSdkValue, projectApiLevel));
                    }
                    break block12;
                }
                System.out.println("WARNING: No minSdkVersion value set. Application will install on all Android versions.");
            }
            catch (XPathExpressionException e) {
                throw new BuildException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void processReferencedLibraries(Project antProject, IAndroidTarget androidTarget) {
        Path sourcePath = new Path(antProject);
        Path resPath = new Path(antProject);
        Path libsPath = new Path(antProject);
        Path jarsPath = new Path(antProject);
        StringBuilder sb = new StringBuilder();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        };
        System.out.println("\n------------------\nResolving library dependencies:");
        ArrayList<File> libraries = this.getProjectLibraries(antProject);
        int libCount = libraries.size();
        if (libCount > 0 && !androidTarget.getProperty("sdk.build.support.library", Boolean.valueOf(false)).booleanValue()) {
            throw new BuildException(String.format("The build system for this project target (%1$s) does not support libraries", androidTarget.getFullName()));
        }
        System.out.println("------------------\nOrdered libraries:");
        for (File library : libraries) {
            String value;
            System.out.println(library.getAbsolutePath());
            Path.PathElement element = sourcePath.createPathElement();
            ProjectProperties prop = ProjectProperties.load((IAbstractFolder)new FolderWrapper(library), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.BUILD);
            String sourceDir = "src";
            if (prop != null && (value = prop.getProperty("source.dir")) != null) {
                sourceDir = value;
            }
            String path = library.getAbsolutePath();
            element.setPath(path + "/" + sourceDir);
            element = resPath.createPathElement();
            element.setPath(path + "/" + "res");
            element = libsPath.createPathElement();
            element.setPath(path + "/" + "libs");
            File libsFolder = new File(library, "libs");
            File[] jarFiles = libsFolder.listFiles(filter);
            if (jarFiles != null) {
                for (File jarFile : jarFiles) {
                    element = jarsPath.createPathElement();
                    element.setPath(jarFile.getAbsolutePath());
                }
            }
            FileWrapper manifest = new FileWrapper(library, "AndroidManifest.xml");
            try {
                String value2 = AndroidManifest.getPackage((IAbstractFile)manifest);
                if (value2 == null) continue;
                sb.append(';');
                sb.append(value2);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        System.out.println("------------------\n");
        antProject.addReference("android.libraries.src", (Object)sourcePath);
        antProject.addReference("android.libraries.jars", (Object)jarsPath);
        antProject.addReference("android.libraries.libs", (Object)libsPath);
        if (sourcePath.list().length > 0) {
            antProject.addReference("android.libraries.res", (Object)resPath);
            antProject.setProperty("android.libraries.package", sb.toString());
        }
    }

    private ArrayList<File> getProjectLibraries(final Project antProject) {
        ArrayList<File> libraries = new ArrayList<File>();
        File baseDir = antProject.getBaseDir();
        ArrayList<File> topLevelLibraries = this.getDirectDependencies(baseDir, new IPropertySource(){

            public String getProperty(String name) {
                return antProject.getProperty(name);
            }
        });
        this.resolveFullLibraryDependencies(topLevelLibraries, libraries);
        return libraries;
    }

    private void resolveFullLibraryDependencies(ArrayList<File> inLibraries, ArrayList<File> outLibraries) {
        for (int i = inLibraries.size() - 1; i >= 0; --i) {
            File library = inLibraries.get(i);
            final ProjectProperties defaultProp = ProjectProperties.load((IAbstractFolder)new FolderWrapper(library), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
            ArrayList<File> dependencies = this.getDirectDependencies(library, new IPropertySource(){

                public String getProperty(String name) {
                    return defaultProp.getProperty(name);
                }
            });
            this.resolveFullLibraryDependencies(dependencies, outLibraries);
            if (outLibraries.contains(library)) continue;
            outLibraries.add(0, library);
        }
    }

    private ArrayList<File> getDirectDependencies(File baseFolder, IPropertySource source) {
        String propName;
        String rootPath;
        ArrayList<File> libraries = new ArrayList<File>();
        int index = 1;
        while ((rootPath = source.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
            try {
                File library = new File(baseFolder, rootPath).getCanonicalFile();
                File defaultProp = new File(library, ProjectProperties.PropertyType.DEFAULT.getFilename());
                if (!defaultProp.isFile()) {
                    throw new BuildException(String.format("%1$s resolve to a path with no %2$s file for project %3$s", rootPath, ProjectProperties.PropertyType.DEFAULT.getFilename(), baseFolder.getAbsolutePath()));
                }
                if (libraries.contains(library)) continue;
                System.out.println(String.format("%1$s: %2$s => %3$s", baseFolder.getAbsolutePath(), rootPath, library.getAbsolutePath()));
                libraries.add(library);
            }
            catch (IOException e) {
                throw new BuildException("Failed to resolve library path: " + rootPath, (Throwable)e);
            }
        }
        return libraries;
    }

    public static interface IPropertySource {
        public String getProperty(String var1);
    }
}

