/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ApkBuilderTask
extends Task {
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);
    private String mOutFolder;
    @Deprecated
    private String mBaseName;
    private String mApkFilepath;
    private String mResourceFile;
    private boolean mVerbose = false;
    private boolean mSigned = true;
    private boolean mDebug = false;
    private boolean mHasCode = true;
    private String mAbiFilter = null;
    private Path mDexPath;
    private final ArrayList<Path> mZipList = new ArrayList();
    private final ArrayList<Path> mFileList = new ArrayList();
    private final ArrayList<Path> mSourceList = new ArrayList();
    private final ArrayList<Path> mJarfolderList = new ArrayList();
    private final ArrayList<Path> mJarfileList = new ArrayList();
    private final ArrayList<Path> mNativeList = new ArrayList();

    public void setOutfolder(Path outFolder) {
        this.mOutFolder = TaskHelper.checkSinglePath("outfolder", outFolder);
    }

    public void setBasename(String baseName) {
        System.out.println("WARNING: Using deprecated 'basename' attribute in ApkBuilderTask.Use 'apkfilepath' (path) instead.");
        this.mBaseName = baseName;
    }

    public void setApkfilepath(String filepath) {
        this.mApkFilepath = filepath;
    }

    public void setResourcefile(String resourceFile) {
        this.mResourceFile = resourceFile;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setSigned(boolean signed) {
        this.mSigned = signed;
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public void setAbifilter(String abiFilter) {
        this.mAbiFilter = abiFilter != null && abiFilter.length() > 0 ? abiFilter.trim() : null;
    }

    public void setHascode(boolean hasCode) {
        this.mHasCode = hasCode;
    }

    public Object createZip() {
        Path path = new Path(this.getProject());
        this.mZipList.add(path);
        return path;
    }

    public Object createDex() {
        if (this.mDexPath == null) {
            this.mDexPath = new Path(this.getProject());
            return this.mDexPath;
        }
        throw new BuildException("Only one <dex> inner element can be provided");
    }

    public Object createFile() {
        System.out.println("WARNING: Using deprecated <file> inner element in ApkBuilderTask.Use <dex path=...> instead.");
        Path path = new Path(this.getProject());
        this.mFileList.add(path);
        return path;
    }

    public Object createSourcefolder() {
        Path path = new Path(this.getProject());
        this.mSourceList.add(path);
        return path;
    }

    public Object createJarfolder() {
        Path path = new Path(this.getProject());
        this.mJarfolderList.add(path);
        return path;
    }

    public Object createJarfile() {
        Path path = new Path(this.getProject());
        this.mJarfileList.add(path);
        return path;
    }

    public Object createNativefolder() {
        Path path = new Path(this.getProject());
        this.mNativeList.add(path);
        return path;
    }

    public void execute() throws BuildException {
        File outputFile;
        Project antProject = this.getProject();
        String rulesRevStr = antProject.getProperty("android.ant.rules.revision");
        int rulesRev = 1;
        try {
            rulesRev = Integer.parseInt(rulesRevStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.mApkFilepath != null) {
            outputFile = new File(this.mApkFilepath);
        } else if (rulesRev == 2) {
            outputFile = this.mSigned ? new File(this.mOutFolder, this.mBaseName + "-debug-unaligned.apk") : new File(this.mOutFolder, this.mBaseName + "-unsigned.apk");
        } else {
            throw new BuildException("missing attribute 'apkFilepath'");
        }
        File dexFile = null;
        if (this.mHasCode) {
            String[] dexFiles = this.mDexPath.list();
            if (dexFiles.length != 1) {
                throw new BuildException(String.format("Expected one dex file but path value resolve to %d files.", dexFiles.length));
            }
            dexFile = new File(dexFiles[0]);
        }
        try {
            File folder;
            if (this.mSigned) {
                System.out.println(String.format("Creating %s and signing it with a debug key...", outputFile.getName()));
            } else {
                System.out.println(String.format("Creating %s for release...", outputFile.getName()));
            }
            ApkBuilder apkBuilder = new ApkBuilder(outputFile, new File(this.mOutFolder, this.mResourceFile), dexFile, this.mSigned ? ApkBuilder.getDebugKeystore() : null, this.mVerbose ? System.out : null);
            apkBuilder.setDebugMode(this.mDebug);
            for (Path pathList : this.mZipList) {
                for (String path : pathList.list()) {
                    apkBuilder.addZipFile(new File(path));
                }
            }
            for (Path pathList : this.mFileList) {
                for (String path : pathList.list()) {
                    File f = new File(path);
                    apkBuilder.addFile(f, f.getName());
                }
            }
            if (this.mHasCode) {
                for (Path pathList : this.mSourceList) {
                    for (String path : pathList.list()) {
                        apkBuilder.addSourceFolder(new File(path));
                    }
                }
            }
            for (Path pathList : this.mJarfolderList) {
                for (String path : pathList.list()) {
                    String[] filenames;
                    folder = new File(path);
                    if (!folder.isDirectory()) continue;
                    for (String filename : filenames = folder.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return PATTERN_JAR_EXT.matcher(name).matches();
                        }
                    })) {
                        apkBuilder.addResourcesFromJar(new File(folder, filename));
                    }
                }
            }
            for (Path pathList : this.mJarfileList) {
                for (String path : pathList.list()) {
                    apkBuilder.addResourcesFromJar(new File(path));
                }
            }
            for (Path pathList : this.mNativeList) {
                for (String path : pathList.list()) {
                    folder = new File(path);
                    if (!folder.isDirectory()) continue;
                    apkBuilder.addNativeLibraries(folder, this.mAbiFilter);
                }
            }
            apkBuilder.sealApk();
        }
        catch (DuplicateFileException e) {
            System.err.println(String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", e.getArchivePath(), e.getFile1(), e.getFile2()));
            throw new BuildException((Throwable)e);
        }
        catch (ApkCreationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SealedApkException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

