/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class AidlExecTask
extends Task {
    private String mExecutable;
    private String mFramework;
    private String mGenFolder;
    private final ArrayList<Path> mPaths = new ArrayList();

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setFramework(Path value) {
        this.mFramework = TaskHelper.checkSinglePath("framework", value);
    }

    public void setGenFolder(Path value) {
        this.mGenFolder = TaskHelper.checkSinglePath("genFolder", value);
    }

    public Path createSource() {
        Path p = new Path(this.getProject());
        this.mPaths.add(p);
        return p;
    }

    public void execute() throws BuildException {
        if (this.mFramework == null) {
            throw new BuildException("AidlExecTask's framework is required.");
        }
        if (this.mGenFolder == null) {
            throw new BuildException("AidlExecTask's genFolder is required.");
        }
        Project taskProject = this.getProject();
        ArrayList<String> sourceFolders = new ArrayList<String>();
        for (Path p : this.mPaths) {
            String[] values = p.list();
            if (values == null) continue;
            sourceFolders.addAll(Arrays.asList(values));
        }
        for (String sourceFolder : sourceFolders) {
            FileSet fs = new FileSet();
            fs.setProject(taskProject);
            fs.setDir(new File(sourceFolder));
            PatternSet.NameEntry include = fs.createInclude();
            include.setName("**/*.aidl");
            for (Object next : fs) {
                ExecTask task = new ExecTask();
                task.setProject(taskProject);
                task.setOwningTarget(this.getOwningTarget());
                task.setExecutable(this.mExecutable);
                task.setFailonerror(true);
                task.createArg().setValue("-p" + this.mFramework);
                task.createArg().setValue("-o" + this.mGenFolder);
                for (String importFolder : sourceFolders) {
                    task.createArg().setValue("-I" + importFolder);
                }
                task.createArg().setValue(next.toString());
                task.execute();
            }
        }
    }
}

