(defvar mpc-mode-hook nil)
(defvar mpc-mode-map
  (let ((mpc-mode-map (make-keymap)))
    (define-key mpc-mode-map "\C-j" 'newline-and-indent)
    mpc-mode-map)
  "Keymap for MPC major mode")

(add-to-list 'auto-mode-alist '("\\.mpc\\'" . mpc-mode))

; "exename " "sharedname " "staticname " "buildflags " "dllout " "libout " "exeout " "no_pch " "pch_header " "pch_source " "postbuild " "prebuild " "recurse " "version " "macros " "libpaths " "includes " "libs " "lit_libs " "pure_libs " "after " "custom_only " "dynamicflags " "staticflags " "verbatim " "specific " "expand " "conditional " "requires " "avoids " "webapp " "dependent_upon " "generates_source " "subtype " 

; "project" "workspace" "feature"

(defconst mpc-font-lock-keywords
  (list
   '("\\(\\(?:a\\(?:fter\\|voids\\)\\|buildflags\\|c\\(?:onditional\\|ustom_only\\)\\|d\\(?:ependent_upon\\|llout\\|ynamicflags\\)\\|ex\\(?:e\\(?:name\\|out\\)\\|pand\\)\\|generates_source\\|includes\\|li\\(?:b\\(?:out\\|\\(?:path\\)?s\\)\\|t_libs\\)\\|macros\\|no_pch\\|p\\(?:ch_\\(?:header\\|source\\)\\|ostbuild\\|rebuild\\|ure_libs\\)\\|re\\(?:curse\\|quires\\)\\|s\\(?:haredname\\|pecific\\|tatic\\(?:flags\\|name\\)\\|ubtype\\)\\|ver\\(?:batim\\|sion\\)\\|webapp\\) \\)" . font-lock-variable-name-face)
   '("feature\\|project\\|workspace" . font-lock-keyword-face)
   '("[A-Za-z-_]+_Files " . font-lock-keyword-face)
   ) "MPC highlighting expressions.")


;; Indenting logic
(defun mpc-indent-line ()
  "Indent current line as MPC directives"
  (interactive)
  (beginning-of-line)

  (if (bobp)
      (indent-line-to 0) ; if we are at start of file, zero indent
    (let ((not-found-hint t) cur-indent (close-brace nil))
      (save-excursion ; otherwise, we are not looking at a }, so we need to go back to find the
        (if (looking-at ".*}")
            (setq close-brace t))
        (while not-found-hint ; nearest indentation hint
          (forward-line -1)
          (if (looking-at ".*{")
              (progn
                (setq cur-indent (+ (current-indentation) default-tab-width))
                (setq not-found-hint nil))
            (if (looking-at ".*}")
                (progn
                  (setq cur-indent (current-indentation))
                  (if (< cur-indent 0)
                      (setq cur-indent 0))
                  (setq not-found-hint nil))
              (if (bobp)
                  (setq not-found-hint nil))))))
      (if close-brace
          (setq cur-indent (- cur-indent default-tab-width)))
      (if cur-indent
          (indent-line-to cur-indent)
        (indent-line-to 0)))))

;; Create a syntax table.  Derived from fundamental mode, it will automatically
;; highlight strings, and behave correctly on most words.
(defvar mpc-mode-syntax-table () "mpc-mode syntax table")
(setq mpc-mode-syntax-table (make-syntax-table))
(modify-syntax-entry ?_ "w" mpc-mode-syntax-table) ; underscore is a valid part of a word
(modify-syntax-entry ?- "w" mpc-mode-syntax-table) ; hyphen is a valid part of a word
(modify-syntax-entry ?/ ". 12b" mpc-mode-syntax-table) ; c++-style comments
(modify-syntax-entry ?\n "> b" mpc-mode-syntax-table) ; c++-style comments

(defun mpc-mode ()
  "Major mode for editing MPC related files"
  (interactive)
  (kill-all-local-variables)
  (use-local-map mpc-mode-map)
  (set-syntax-table mpc-mode-syntax-table)

  (set (make-local-variable 'font-lock-defaults) '(mpc-font-lock-keywords))
  (set (make-local-variable 'indent-line-function) 'mpc-indent-line) 

  (setq major-mode 'mpc-mode)
  (setq mode-name "MPC")
  (run-hooks 'mpc-mode-hook))

(provide 'mpc-mode)