;;------------------------------message-x.el------------------------------
;;
;; message-x.el -- customizable completion in message headers
;;              Kai Grossjohann <grossjohann@ls6.informatik.uni-dortmund.de>
;;  6 Mar 97

(defvar message-x-body-function 'indent-relative
  "message-x-tab executes this if point is in the body of a message.")

(defvar message-x-completion-alist
  '(("to" . message-x-complete-name)
    ("cc" . message-x-complete-name)
    ("bcc" . message-x-complete-name)
    ("resent-to" . message-x-complete-name)
    ("resent-cc" . message-x-complete-name)
    ("resent-bcc" . message-x-complete-name)
    ("gcc" . message-expand-group)
    ("newsgroups" . message-expand-group))
  "Table telling which completion function message-x-tab should invoke.
Lookup in the table is done with `equal' comparison of the header.")

(defun message-x-in-header-p ()
  "Returns t iff point is in the header section."
  (save-excursion
    (let ((p (point)))
      (beginning-of-buffer)
      (and (re-search-forward (concat "^"
                                      (regexp-quote mail-header-separator)
                                      "$"))
           (progn (beginning-of-line) t)
           (< p (point))))))


(defun message-x-which-header ()
  "Returns the header we're currently in.  Returns nil if not in a header.
Example: returns \"to\" if we're in the \"to\" header right now."
  (and (message-x-in-header-p)
       (save-excursion
         (beginning-of-line)
         (while (looking-at "^[ \t]+") (forward-line -1))
         (looking-at "\\([^:]+\\):")
         (downcase (buffer-substring-no-properties (match-beginning 1)
                                                   (match-end 1))))))

(defun message-x-complete-name ()
  "Does name completion in recipient headers."
  (interactive)
  (if (fboundp 'bbdb-complete-name)
      (bbdb-complete-name)
    (expand-abbrev)))

(defun message-x-tab ()
  "Does completion based on header currently in or executes a default
function in the body."
  (interactive)
  (let ((header (assoc (message-x-which-header)
                       message-x-completion-alist)))
    (funcall
     (if header (cdr header) message-x-body-function))))

(provide 'message-x)
;; message-x ends here
